//
//  YHSelectApplicantCell.swift
//  galaxy
//
//  Created by edy on 2024/8/19.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHSelectApplicantCell: UICollectionViewCell {

    static let cellReuseIdentifier = "YHSelectApplicantCell"

    lazy var selectImgView:UIImageView = {
        let view = UIImageView(image: UIImage(named: ""))
        return view
    }()
    
    lazy var nameLabel: UILabel = {
        let label = UILabel()
        label.font = UIFont.PFSC_R(ofSize: 14)
        label.textColor = .mainTextColor
        return label
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        createUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func createUI() {
        self.addSubview(selectImgView)
        self.addSubview(nameLabel)
        
        selectImgView.snp.makeConstraints { make in
            make.left.equalTo(0)
            make.width.height.equalTo(14)
            make.centerY.equalToSuperview()
        }
        
        nameLabel.snp.makeConstraints { make in
            make.left.equalTo(selectImgView.snp.right).offset(6)
            make.centerY.equalToSuperview()
            make.right.equalToSuperview()
        }
    }
    
    func updateApplicantInfo(_ applicant: YHHKMemberModel) {
        nameLabel.text = applicant.name
        let imgName = applicant.isSelected ? "login_privacy_agree" :  "login_privacy_disagree_glay"
        selectImgView.image = UIImage(named: imgName)
    }
}
